IF OBJECT_ID('UFD_EXP_CTB_MOV_CHQ_DEPOS') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_CHQ_DEPOS
	END
	
GO 
  
 
CREATE FUNCTION UFD_EXP_CTB_MOV_CHQ_DEPOS(	@CD_EMP		INT,
											@CD_FILIAL	INT,
											@DT_INI		DATETIME,
											@DT_FIM		DATETIME)		
RETURNS @RS_RETURN TABLE(
			CD_EMP					INT,
			CD_FILIAL				INT,
			DT_DEPOS				DATETIME,
			HIST_LANC				VARCHAR(150),
			VALORDEPOSITO			MONEY,
			CD_CNT					INT,
			CD_CNT_ORIG				INT,
			TP_CHQ					INT,
			CD_DEPOS				     INT) 			
AS
BEGIN       
	
	DECLARE @CD_GRP_ECON			INT
	
	SET @CD_GRP_ECON = (SELECT PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
						FROM PRC_FILIAL
							INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
								PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
								PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
						WHERE
						    PRC_FILIAL.CD_EMP = @CD_EMP
						    AND PRC_FILIAL.CD_FILIAL = @CD_FILIAL
						    AND PRC_FILIAL.FILIAL_MTZ_GRP_ECON = 1)
	
	IF ISNULL(@CD_GRP_ECON,0) = 0 
		BEGIN
			RETURN
		END
		
	INSERT INTO @RS_RETURN 	
		SELECT 
			CHQ_DEPOS.CD_EMP,	
			@CD_FILIAL AS CD_FILIAL,
			CHQ_DEPOS.DT_DEPOS,
			BC_LANC.HIST_LANC,
			BC_LANC.VLR_LANC AS VALORDEPOSITO,
			CHQ_DEPOS.CD_CNT,
			0 AS CD_CNT_ORIG,
			0 AS TP_CHQ,
			CHQ_DEPOS.CD_DEPOS					
		FROM CHQ_LANC_CUSTODIA 
			INNER JOIN CHQ_LANC_CUSTODIA_CHQ_DEPOS ON 
				CHQ_LANC_CUSTODIA.CD_EMP		= CHQ_LANC_CUSTODIA_CHQ_DEPOS.CD_EMP AND
				CHQ_LANC_CUSTODIA.ANO			= CHQ_LANC_CUSTODIA_CHQ_DEPOS.ANO AND
				CHQ_LANC_CUSTODIA.CD_CUSTODIA	= CHQ_LANC_CUSTODIA_CHQ_DEPOS.CD_CUSTODIA 
			INNER JOIN CHQ_DEPOS ON 
				CHQ_LANC_CUSTODIA_CHQ_DEPOS.CD_EMP = CHQ_DEPOS.CD_EMP AND
				CHQ_LANC_CUSTODIA_CHQ_DEPOS.ANO = CHQ_DEPOS.ANO AND
				CHQ_LANC_CUSTODIA_CHQ_DEPOS.CD_DEPOS = CHQ_DEPOS.CD_DEPOS 
			INNER JOIN BC_LANC_CHQ_LANC_CUSTODIA ON 
				CHQ_LANC_CUSTODIA.CD_EMP = BC_LANC_CHQ_LANC_CUSTODIA.CD_EMP AND
				CHQ_LANC_CUSTODIA.ANO = BC_LANC_CHQ_LANC_CUSTODIA.ANO AND
				CHQ_LANC_CUSTODIA.CD_CUSTODIA = BC_LANC_CHQ_LANC_CUSTODIA.CD_CUSTODIA 
			INNER JOIN BC_LANC ON 
				BC_LANC_CHQ_LANC_CUSTODIA.CD_EMP = BC_LANC.CD_EMP AND
				BC_LANC_CHQ_LANC_CUSTODIA.CD_BC_LANC = BC_LANC.CD_BC_LANC
		    
		WHERE 
			CHQ_DEPOS.CD_EMP		= @CD_EMP 
			AND CHQ_DEPOS.DT_DEPOS  BETWEEN @DT_INI AND @DT_FIM
			AND BC_LANC_CHQ_LANC_CUSTODIA.TP_LANC = 1 
			AND BC_LANC.TP_LANC 	= 1
			AND CHQ_DEPOS.CD_CNT 	IN (SELECT CD_CNT FROM BC_CONTAS_PRC_GRP_ECON WHERE CD_EMP =  @CD_EMP  AND CD_GRP_ECON = @CD_GRP_ECON) 
			AND CHQ_LANC_CUSTODIA.DT_CUSTODIA = CHQ_DEPOS.DT_DEPOS
	    
    UNION ALL
    
    SELECT 
		CHQ_DEPOS.CD_EMP,
		@CD_FILIAL AS CD_FILIAL,
		CHQ_DEPOS.DT_DEPOS, 
		BC_LANC.HIST_LANC, 
		BC_LANC.VLR_LANC, 
		CHQ_DEPOS.CD_CNT, 
		CHQ_DEPOS.CD_CNT_ORIG,
		1 AS TP_CHQ,
		CHQ_DEPOS.CD_DEPOS 
    
    FROM CHQ_DEPOS 
		INNER JOIN BC_LANC_CHQ_DEPOS ON 
			CHQ_DEPOS.CD_EMP = BC_LANC_CHQ_DEPOS.CD_EMP AND 
			CHQ_DEPOS.ANO = BC_LANC_CHQ_DEPOS.ANO AND
			CHQ_DEPOS.CD_DEPOS = BC_LANC_CHQ_DEPOS.CD_DEPOS 
		INNER JOIN BC_LANC ON 
			BC_LANC_CHQ_DEPOS.CD_EMP = BC_LANC.CD_EMP AND 
			BC_LANC_CHQ_DEPOS.CD_BC_LANC = BC_LANC.CD_BC_LANC
    WHERE 
		CHQ_DEPOS.CD_EMP		= @CD_EMP
		AND CHQ_DEPOS.DT_DEPOS  BETWEEN @DT_INI AND @DT_FIM
		AND CHQ_DEPOS.CD_CNT	IN (SELECT CD_CNT FROM BC_CONTAS_PRC_GRP_ECON WHERE CD_EMP = @CD_EMP AND CD_GRP_ECON = @CD_GRP_ECON)		
		AND BC_LANC.TP_LANC = 0
    
    ORDER BY CHQ_DEPOS.DT_DEPOS, HIST_LANC
    
   RETURN
    
END    